(function ($) {
    $(document).ready(function () {
        $('.pro-slider-wp').each(function () {
            const sliderModule = $(this);
            const mainSwiperContainer = sliderModule.find('.pro-slider-main');
            if (!mainSwiperContainer.length) { return; }

            const settings = window.proSliderSettings || {};

            // SADECE ANA SLIDER'I BAŞLAT
            const mainSwiper = new Swiper(mainSwiperContainer[0], {
                effect: settings.effect || 'slide',
                loop: true,
                autoplay: settings.autoplay ? {
                    delay: settings.delay || 5000,
                    disableOnInteraction: false,
                    pauseOnMouseEnter: true,
                } : false,
                pagination: settings.show_pagination ? {
                    el: sliderModule.find('.swiper-pagination')[0],
                    clickable: true,
                } : false,
                navigation: settings.show_arrows ? {
                    nextEl: sliderModule.find('.pro-slider-next-btn')[0],
                    prevEl: sliderModule.find('.pro-slider-prev-btn')[0],
                } : false,
            });

            // KÜÇÜK RESİMLERİN TIKLAMA OLAYLARI (EĞER VARSA)
            const thumbnails = sliderModule.find('.thumbnail-item');
            if (thumbnails.length > 0) {
                // Bir küçük resme tıklandığında
                thumbnails.on('click', function () {
                    const slideIndex = $(this).data('index');
                    // Ana slider'ı o slayta götür (loop olduğu için slideToLoop kullanıyoruz)
                    mainSwiper.slideToLoop(slideIndex);
                });

                // Ana slider her değiştiğinde
                mainSwiper.on('slideChange', function () {
                    // Önce tüm thumbnail'lerden aktif sınıfını kaldır
                    thumbnails.removeClass('is-active');
                    // Sadece o anki slaytın index'ine sahip olan thumbnail'e aktif sınıfını ekle
                    sliderModule.find('.thumbnail-item[data-index="' + mainSwiper.realIndex + '"]').addClass('is-active');
                });

                // Başlangıçta ilk thumbnail'i aktif yap
                sliderModule.find('.thumbnail-item[data-index="0"]').addClass('is-active');
            }
        });
    });
})(jQuery);